const express = require('express');
const path = require('path');
const app = express();
const bodyParser = require('body-parser');
const cookieParser = require("cookie-parser");
const mongoose = require('mongoose');
const sessions = require('express-session');
const MongoStore = require('connect-mongo')(sessions);
const keys = require('./config/keys')
// const flash = require('connect-flash');
// const https = require('https');
const https = require('http');
const fs = require('fs');
require('dotenv').config();

// const MongoDBURI = process.env.MONGO_URI || 'mongodb://127.0.0.1:27017/gunjanapps_yoga';
const MongoDbURI = process.env.MONGO_URI;
mongoose.connect(MongoDbURI, {
  useUnifiedTopology: true,
  useNewUrlParser: true
});

const db = mongoose.connection;
db.on('error', console.error.bind(console, 'connection error:'));
db.once('open', () => {
});

app.use(express.json());
const oneDay = 1000 * 60 * 60 * 24 * 365;  // One Year
// const oneDay = 700;
// ---------------------------------------------
app.use(sessions({
  secret: keys.secret,
  resave: true,
  secure: true,
  saveUninitialized: false,
  cookie: { maxAge: oneDay },
  store: new MongoStore({
    mongooseConnection: db
  })
}));
// --------------------------------------------
// app.use(sessions({
//   secret: keys.secret,
//   // resave: true,
//   resave: false,
//   secure: true,
//   // saveUninitialized: false,
//   saveUninitialized: true,
//   cookie: { maxAge: oneDay },
//   store: new MongoStore({
//     mongooseConnection: db
//   })
// }));
// -----------------session end---------------------------
// ---------------------------For Server Start---------------
// const options = {
//   key: fs.readFileSync('./config/inmotionhosting.com.key'),
//   cert: fs.readFileSync('./config/inmotionhosting.com.crt')
// };
// const server = https.createServer(options, app);

// ---------------------------For Server End---------------
app.use(cookieParser());


app.set('views', path.join(__dirname, 'views'));
app.set('view engine', 'ejs');

app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: false }));

app.use(express.static(__dirname + '/views'));

const index = require('./routes/web');
app.use('/', index);

// catch 404 and forward to error handler
app.use((req, res, next) => {
  const err = new Error('File Not Found');
  err.status = 404;
  next(err);
});

// error handler
// define as the last app.use callback
app.use((err, req, res, next) => {
  res.status(err.status || 500);
  res.send(err.message);
});
const port = process.env.PORT || 4002
const hostname = process.env.HOST || '127.0.0.1';
// listen on port 3000
// app.listen(port, () => {
//   console.log(`app are running on http://localhost:${port}`);
// });
// ----------------------------------------------------------
// server.listen(port, () => {
//   console.log(`Server running on port ${port}`);
// });
// ----------------------------------------------------------
// server.listen(port, hostname, () => { 
//     console.log(`Server running at http://${hostname}:${port}/`);
// });
// -------------------------------------------------------------
// listen on port 3000
app.listen(port, hostname, () => { 
    console.log(`Server running at http://${hostname}:${port}/`);
});