const Weight = require('../models/weight_track')
const User = require('../models/user')
const M_session = require('../models/mannual__session')

class WeightController {
    static async weightDataStore(req, res) {
        try {
            if (!req.body.session.userId) {
                return res.send({ "message": 'You have no access for updating this profile. Please login and try!!', 'code': 401 });
            }

            const session_data = await M_session.findOne({ user_id: req.body.session.userId }).exec();

            if (!session_data) {
                return res.send({ "message": 'Please Sign in!!', 'data': null, 'code': 401 });
            }

            const sessiondata = await User.findOne({ _id: req.body.session.userId }).exec();

            if (!req.body.email) {
                return res.send({ 'message': 'Please enter all fields', 'code': 204 });
            }

            let existsWeight = await Weight.findOne({ email: sessiondata.email }).exec();

            if (!existsWeight) {
                const { email, date, weight } = req.body;

                let newWeight = new Weight({
                    email: sessiondata.email,
                    weight: weight,
                    date: date,
                });

                await newWeight.save();
                return res.send({ 'message': "WeightData has been saved successfully!!", "data": newWeight, 'code': 200 });
            } else {
                const { email, weight, date } = req.body;

                if (email) existsWeight.email = email;
                if (date) existsWeight.date = date;
                if (weight) existsWeight.weight = weight;

                // Save the updated WeightData
                await existsWeight.save();
                return res.send({ 'message': 'WeightData has been updated successfully!!', 'data': existsWeight, 'code': 200 });
            }
        } catch (error) {
            console.error('An error occurred:', error);
            return res.send({ 'message': 'An internal server error occurred.', 'data': error, 'code': 500 });
        }
    }


    static async weightDataGet(req, res) {
        try {
            const { email, session } = req.body
            const emailUser = await User.findOne({ email: email }).exec();
            if (!emailUser) {
                return res.send({ "message": 'You have no access for updating this profile. Please login and try!!', 'code': 401 });
            }

            const session_data = await M_session.findOne({ user_id: emailUser._id }).exec();

            if (!session_data) {
                return res.send({ "message": 'Please Sign in!!', 'data': null, 'code': 401 });
            }


            const data = await Weight.findOne({ email: email }).exec();

            if (!data) {
                return res.send({ 'message': 'Weight not found.', 'code': 404 });
            }

            res.send({ 'message': 'Weight retrieved successfully.', 'data': data, 'code': 200 });
        } catch (error) {
            console.error('An error occurred:', error);
            res.send({ 'message': 'An internal server error occurred.', 'data': error, 'code': 500 });
        }
    }

    static async weightDataDelete(req, res) {
        try {
            if (!req.session.userId) {
                return res.send({ 'message': 'Unauthorized: Please log in to access this page.', 'code': 401 });
            }
            // console.log(`Unauthorized access attempt in line 52...${req.session.userId}`);
            const userdata = await User.findOne({ _id: req.session.userId }).exec();

            if (!userdata) {
                return res.send({ 'message': 'Missing required field!!', 'code': 400 });
            }

            const data = await Weight.deleteOne({ email: userdata.email }).exec();

            if (!data) {
                return res.send({ 'message': 'Weight not found.', 'code': 404 });
            }

            res.send({ 'message': 'Weight deleted successfully.', 'data': data, 'code': 200 });
        } catch (error) {
            res.send({ 'message': 'An internal server error occurred.', 'data': error, 'code': 500 });
        }
    }
}


module.exports = WeightController