const Coin = require('../models/coin')
const User = require('../models/user')
const M_session = require('../models/mannual__session')

class CoinController {
    static async coinDataStore(req, res) {
        try {
            if (!req.body.session.userId) {
                return res.send({ "message": 'You have no access for updating this profile. Please login and try!!', 'code': 401 });
            }

            const session_data = await M_session.findOne({ user_id: req.body.session.userId }).exec();

            if (!session_data) {
                return res.send({ "message": 'Please Sign in!!', 'data': null, 'code': 401 });
            }

            const sessiondata = await User.findOne({ _id: req.body.session.userId }).exec();

            if (!req.body.email) {
                return res.send({ 'message': 'Please enter all fields', 'code': 204 });
            }

            let existscoin = await Coin.findOne({ email: sessiondata.email }).exec();

            if (!existscoin) {
                const { total_count, date } = req.body;

                let newCoin = new Coin({
                    email: sessiondata.email,
                    total_count: total_count,
                    date: date,
                });

                await newCoin.save();
                return res.send({ 'message': "coinData has been saved successfully!!", "data": newCoin, 'code': 200 });
            } else {
                const { total_count, date } = req.body;

                if (total_count) existscoin.total_count = total_count;
                if (date) existscoin.date = date;

                // Save the updated coinData
                await existscoin.save();
                return res.send({ 'message': 'coinData has been updated successfully!!', 'data': existscoin, 'code': 200 });
            }
        } catch (error) {
            console.error('An error occurred:', error);
            return res.send({ 'message': 'An internal server error occurred.', 'data': error, 'code': 500 });
        }
    }


    static async coinDataGet(req, res) {
        try {
            if (!req.body.session.userId) {
                return res.send({ "message": 'Unauthorized: Please log in to access this page.', 'code': 401 });
            }

            const session_data = await M_session.findOne({ user_id: req.body.session.userId }).exec();

            if (!session_data) {
                return res.send({ "message": 'Please Sign in!!', 'data': null, 'code': 401 });
            }

            const userdata = await User.findOne({ _id: req.body.session.userId }).exec();

            if (!userdata) {
                return res.send({ 'message': 'Missing required field!!', 'code': 400 });
            }

            const data = await Coin.findOne({ email: userdata.email }).exec();

            if (!data) {
                return res.send({ 'message': 'Coin not found.', 'code': 404 });
            }

            return res.send({ 'message': 'Coin retrieved successfully.', 'data': data, 'code': 200 });
        } catch (error) {
            console.error('An error occurred:', error);
            return res.send({ 'message': 'An internal server error occurred.', 'data': error, 'code': 500 });
        }
    }

}

module.exports = CoinController