const express = require('express');
const router = express.Router();
const userController = require('../controllers/userController')
const subscriptionController = require('../controllers/subscriptionController')
const gameController = require('../controllers/gameController')
const iapController = require('../controllers/iapController')
const coinController = require('../controllers/coinController')
const weightController = require('../controllers/weightController')
const daysChallengeController = require('../controllers/daysChallengeController')
const musicController = require('../controllers/musicController')

router.post('/profile', userController.profile);
router.post('/logout', userController.logout);
router.post('/signin', userController.submitForm)
router.post('/otp', userController.otpForm)
router.post('/',subscriptionController.subscribe)
router.get('/', (req, res)=>{
    res.send(`Workout's Server Are Running...`);
})
router.post('/profile_update',userController.profileUpdate)
// ---------------------------------Game Data Function start-----------------------
router.post('/gamedataget', gameController.gameDataGet)
router.post('/gamedatastore', gameController.gameDataStore)
// ---------------------------------Game Data Function End-------------------------
// ---------------------------------Iap Data Function start-----------------------
router.post('/iapdataget', iapController.iapDataGet)
router.post('/iapdatastore', iapController.iapDataStore)
// ---------------------------------Iap Data Function End-------------------------
// ---------------------------------Coin Data Function start-----------------------
router.post('/coindataget', coinController.coinDataGet)
router.post('/coindatastore', coinController.coinDataStore)
// ---------------------------------Coin Data Function End-------------------------
// ---------------------------------Weight Tracker Data Function start-----------------------
router.post('/weightdataget', weightController.weightDataGet)
router.post('/weightdatastore', weightController.weightDataStore)
// ---------------------------------Weight Tracker Data Function End-------------------------
// ---------------------------------Weight Tracker Data Function start-----------------------
router.post('/weightdataget', weightController.weightDataGet)
router.get('/weightdatadelete', weightController.weightDataDelete)
router.post('/weightdatastore', weightController.weightDataStore)
// ---------------------------------Weight Tracker Data Function End-------------------------
// ---------------------------------Weight Tracker Data Function start-----------------------
router.post('/dayschallengeget', daysChallengeController.daysChallengeGet)
router.post('/dayschallengedatastore', daysChallengeController.daysChallengeDataStore)
// ---------------------------------Weight Tracker Data Function End-------------------------
// ---------------------------------Music Tracker Data Function start-----------------------
router.post('/musicget', musicController.musicGet)
router.post('/musicstore', musicController.musicStore)
// ---------------------------------Music Tracker Data Function End-------------------------
// -------------------------teacherSignin Data start--------------------------
router.post('/teacher_signin', userController.teacherSignIn)
router.post('/otp_verify', userController.otpVerify)
router.post('/upload_document', userController.uploadDocument)
router.post('/document_verify', userController.documentVerify)
router.post('/document_status', userController.documentStatus)
router.post('/document_fetch', userController.documentFetch)
// -------------------------teacherSignin Data end----------------------------
module.exports = router;