const mongoose = require('mongoose');

const Schema = mongoose.Schema;

const sessionSchema = new Schema({
    session: Object,
    user_id: String,
    expireAt: {
        type: Date,
        required: true
    }
});

// Create a TTL index to automatically expire documents based on the 'expireAt' field
sessionSchema.index({ expireAt: 1 }, { expireAfterSeconds: 0 });

const Session = mongoose.model('manualsession', sessionSchema);

module.exports = Session;
