const Music = require('../models/music')
const User = require('../models/user')
const M_session = require('../models/mannual__session')

class MusicController {
    static async musicStore(req, res) {
        try {
            if (!req.body.session.userId) {
                return res.send({ "message": 'You have no access for updating this profile. Please login and try!!', 'code': 401 });
            }

            const session_data = await M_session.findOne({ user_id: req.body.session.userId }).exec();

            if (!session_data) {
                return res.send({ "message": 'Please Sign in!!', 'data': null, 'code': 401 });
            }

            const sessiondata = await User.findOne({ _id: req.body.session.userId }).exec();

            if (!req.body.email) {
                return res.send({ 'message': 'Please enter all fields', 'code': 204 });
            }
            let existsMusic = await Music.findOne({ email: sessiondata.email }).exec()
            if (!existsMusic) {
                let { email, wind, quiet } = req.body

                let NewMusic = new Music({
                    email: email,
                    quiet: quiet,
                    wind: wind,
                });

                await NewMusic.save();
                res.send({ 'message': "MusicData has been saved successfully!!", "data": NewMusic, 'code': 200 });
            } else {
                let { email, wind, quiet } = req.body;
                if (email) existsMusic.email = email;
                if (quiet) existsMusic.quiet = quiet;
                if (wind) existsMusic.wind = wind;

                // Save the updated page data
                await existsMusic.save();
                res.send({ 'message': 'MusicData has been updated successfully!!', 'data': existsMusic, 'code': 200 });
            }
        } catch (error) {
            res.send({ 'message': 'An internal server error occurred.', 'code': 500 });
        }
    }


    static async musicGet(req, res) {
        try {
            if (!req.body.session.userId) {
                return res.send({ "message": 'Unauthorized: Please log in to access this page.', 'code': 401 });
            }

            const session_data = await M_session.findOne({ user_id: req.body.session.userId }).exec();

            if (!session_data) {
                return res.send({ "message": 'Please Sign in!!', 'data': null, 'code': 401 });
            }

            const userdata = await User.findOne({ _id: req.body.session.userId }).exec();

            if (!userdata) {
                return res.send({ 'message': 'Missing required field!!', 'code': 400 });
            }
            const data = await Music.findOne({ email: userdata.email }).exec();

            if (!data) {
                return res.send({ 'message': 'MusicData not found.', 'code': 404 });
            }

            res.send({ 'message': 'MusicData retrieved successfully.', 'data': data, 'code': 200 });
        } catch (error) {
            console.error('An error occurred:', error);
            res.send({ 'message': 'An internal server error occurred.', 'data': error, 'code': 500 });
        }
    }
}


module.exports = MusicController