const Iap = require('../models/iap')
const User = require('../models/user')
const M_session = require('../models/mannual__session')

class IapController {
    static async iapDataStore(req, res) {
        try {
            if (!req.body.session.userId) {
                return res.send({ "message": 'You have no access for updating this profile. Please login and try!!', 'code': 401 });
            }

            const session_data = await M_session.findOne({ user_id: req.body.session.userId }).exec();

            if (!session_data) {
                return res.send({ "message": 'Please Sign in!!', 'data': null, 'code': 401 });
            }

            const sessiondata = await User.findOne({ _id: req.body.session.userId }).exec();

            if (!req.body.email) {
                return res.send({ 'message': 'Please enter all fields', 'code': 204 });
            }
            let existsiap = await Iap.findOne({ email: sessiondata.email }).exec();

            if (!existsiap) {
                const { ad_removed, purchased_coin, date } = req.body;

                let newIap = new Iap({
                    email: sessiondata.email,
                    ad_removed: ad_removed,
                    purchased_coin: purchased_coin,
                    date: date,
                });

                await newIap.save();
                return res.send({ 'message': "IapData has been saved successfully!!", "data": newIap, 'code': 200 });
            } else {
                const { ad_removed, purchased_coin, date } = req.body;

                if (ad_removed) existsiap.ad_removed = ad_removed;
                if (purchased_coin) existsiap.purchased_coin = purchased_coin;
                if (date) existsiap.date = date;

                // Save the updated IapData
                await existsiap.save();
                return res.send({ 'message': 'IapData has been updated successfully!!', 'data': existsiap, 'code': 200 });
            }
        } catch (error) {
            console.error('An error occurred:', error);
            return res.send({ 'message': 'An internal server error occurred.', 'data': error, 'code': 500 });
        }
    }

    static async iapDataGet(req, res) {
        try {
            if (!req.body.session.userId) {
                return res.send({ "message": 'Unauthorized: Please log in to access this page.', 'code': 401 });
            }

            const session_data = await M_session.findOne({ user_id: req.body.session.userId }).exec();

            if (!session_data) {
                return res.send({ "message": 'Please Sign in!!', 'data': null, 'code': 401 });
            }

            const userdata = await User.findOne({ _id: req.body.session.userId }).exec();

            if (!userdata) {
                return res.send({ 'message': 'Missing required field!!', 'code': 400 });
            }

            const data = await Iap.findOne({ email: userdata.email }).exec();

            if (!data) {
                return res.send({ 'message': 'Iap Data not found.', 'code': 404 });
            }

            return res.send({ 'message': 'Iap Data retrieved successfully.', 'data': data, 'code': 200 });
        } catch (error) {
            console.error('An error occurred:', error);
            return res.send({ 'message': 'An internal server error occurred.', 'data': error, 'code': 500 });
        }
    }


}

module.exports = IapController