const { Session } = require('express-session');
const Game = require('../models/game')
const User = require('../models/user')
const M_session = require('../models/mannual__session')

class GameController {
    static async gameDataStore(req, res) {
        try {
            if (!req.body.session.userId) {
                return res.send({ "message": 'You have no access for updating this profile. Please login and try!!', 'code': 401 });
            }
    
            const session_data = await M_session.findOne({ user_id: req.body.session.userId }).exec();
    
            if (!session_data) {
                return res.send({ "message": 'Please Sign in!!', 'data': null, 'code': 401 });
            }
    
            const sessiondata = await User.findOne({ _id: req.body.session.userId }).exec();
    
            if (!req.body.email) {
                return res.send({ 'message': 'Please enter all fields', 'code': 204 });
            }
    
            let existgame = await Game.findOne({ email: sessiondata.email }).exec();
    
            if (!existgame) {
                const { mats, plants, pets, backgrounds } = req.body;
    
                let newGame = new Game({
                    email: sessiondata.email,
                    mats: mats,
                    plants: plants,
                    pets: pets,
                    backgrounds: backgrounds,
                });
    
                await newGame.save();
                return res.send({ 'message': "GameData has been saved successfully!!", "data": newGame, 'code': 200 });
            } else {
                const { mats, plants, pets, backgrounds } = req.body;
    
                if (mats) existgame.mats = mats;
                if (plants) existgame.plants = plants;
                if (pets) existgame.pets = pets;
                if (backgrounds) existgame.backgrounds = backgrounds;
    
                // Save the updated page data
                await existgame.save();
                return res.send({ 'message': 'GameData has been updated successfully!!', 'data': existgame, 'code': 200 });
            }
        } catch (error) {
            return res.send({ 'message': 'An internal server error occurred.', 'data': error, 'code': 500 });
        }
    }
    

    static async gameDataGet(req, res) {
        try {
            if (!req.body.session.userId) {
                return res.send({ "message": 'Unauthorized: Please log in to access this page.', 'code': 401 });
            }

            const session_data = await M_session.findOne({ user_id: req.body.session.userId }).exec();

            if (!session_data) {
                return res.send({ "message": 'Please Sign in!!', 'data': null, 'code': 401 });
            } else {
                const userSession = await User.findOne({ _id: req.body.session.userId }).exec();

                if (!userSession) {
                    return res.send({ 'message': 'Unauthorized: Please log in to access this page.', 'code': 401 });
                } else {
                    // Store the user data in a variable to avoid redundant queries
                    const userdata = userSession;

                    if (!userdata) {
                        return res.send({ 'message': 'Missing required field!!', 'code': 400 });
                    }

                    const data = await Game.findOne({ email: userdata.email }).exec();

                    if (!data) {
                        return res.send({ 'message': 'Game data not found.', 'code': 404 });
                    }

                    return res.send({ 'message': 'Game data retrieved successfully.', 'data': data, 'code': 200 });
                }
            }
        } catch (error) {
            console.error('An error occurred:', error);
            res.send({ 'message': 'An internal server error occurred.', 'data': error, 'code': 500 });
        }
    }

}

module.exports = GameController