const DaysChallenge = require('../models/days_challenge')
const User = require('../models/user')
const M_session = require('../models/mannual__session')


class DaysChallengeController {
    static async daysChallengeDataStore(req, res) {
        try {
            if (!req.body.session.userId) {
                return res.send({ "message": 'You have no access for updating this profile. Please login and try!!', 'code': 401 });
            }

            const session_data = await M_session.findOne({ user_id: req.body.session.userId }).exec();

            if (!session_data) {
                return res.send({ "message": 'Please Sign in!!', 'code': 401 });
            }

            const sessiondata = await User.findOne({ _id: req.body.session.userId }).exec();

            if (!req.body.email) {
                return res.send({ 'message': 'Please enter all fields', 'code': 204 });
            }

            let existsDaysChallenge = await DaysChallenge.findOne({ email: sessiondata.email }).exec();

            if (!existsDaysChallenge) {
                const { email, day } = req.body;

                let newDaysChallenge = new DaysChallenge({
                    email: sessiondata.email,
                    day: day,
                });

                await newDaysChallenge.save();
                return res.send({ 'message': "DaysChallengeData has been saved successfully!!", "data": newDaysChallenge, 'code': 200 });
            } else {
                const { email, day } = req.body;

                if (email) existsDaysChallenge.email = email;
                if (day) existsDaysChallenge.day = day;

                // Save the updated DaysChallengeData
                await existsDaysChallenge.save();
                return res.send({ 'message': 'DaysChallengeData has been updated successfully!!', 'data': existsDaysChallenge, 'code': 200 });
            }
        } catch (error) {
            console.error('An error occurred:', error);
            return res.send({ 'message': 'An internal server error occurred.', 'data': error, 'code': 500 });
        }
    }


    static async daysChallengeGet(req, res) {
        try {
            if (!req.body.session.userId) {
                return res.send({ "message": 'Unauthorized: Please log in to access this page.', 'code': 401 });
            }

            const session_data = await M_session.findOne({ user_id: req.body.session.userId }).exec();

            if (!session_data) {
                return res.send({ "message": 'Please Sign in!!', 'data': null, 'code': 401 });
            }

            const userdata = await User.findOne({ _id: req.body.session.userId }).exec();

            if (!userdata) {
                return res.send({ 'message': 'Missing required field!!', 'code': 400 });
            }

            const data = await DaysChallenge.findOne({ email: userdata.email }).exec();

            if (!data) {
                return res.send({ 'message': 'DaysChallenge not found.', 'code': 404 });
            }

            res.send({ 'message': 'DaysChallenge retrieved successfully.', 'data': data, 'code': 200 });
        } catch (error) {
            console.error('An error occurred:', error);
            res.send({ 'message': 'An internal server error occurred.', 'data': error, 'code': 500 });
        }
    }
}

module.exports = DaysChallengeController